------------------------------------------------------------------------------
-- Big City under Attack
------------------------------------------------------------------------------
function start1stChapter()

	-- Chests
	CreateChestOpener("Ari")
	CreateChestOpener("Mirai")
	CreateChestOpener("Dario")
	CreateChestOpener("Pilgrim")
	StartChestQuest()
	
	CreateChest(GetPosition("Chest"),openChest)
	
	-- Setup AI
	CreatePlayer2()
	CreatePlayer4()

	-- Spawn troops
	
	CreateQuestMirai()
	CreateQuestKillFirstAttackers()
	
	-- lost if hq destroyed
	AddDefeatEntity("HQ")

end
function end1stChapter()
	
	start2ndChapter()

end
------------------------------------------------------------------------------
-- Introduce Mirai and rescue city
------------------------------------------------------------------------------
function start2ndChapter()

	-- Create mirai entity and let her attack
	Attack(	CreateEntity(5, Entities.PU_Hero11, GetPosition("MiraiSpawn"), "Mirai"),
			"FirstAttackSpawn2")
	MiraiID = GetID("Mirai")
	MakeInvulnerable(MiraiID)
	HPSave = 1000
	MiraiHPTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_HURT_ENTITY,nil,"MiraiHPCalc",1,nil,nil)
	MiraiRegTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_EVERY_SECOND,nil,"MiraiHPReg",1,nil,nil)
	
	Logic.SetShareExplorationWithPlayerFlag(1,5,1)
	
	CreateBriefingMirai()

	CreatePlayer5()
	CreateArmyMirai()	

	CreateQuestRescueCity()

end
function end2ndChapter()

	MakeVulnerable("Mirai")
	Trigger.UnrequestTrigger(MiraiHPTrigger)
	Trigger.UnrequestTrigger(MiraiRegTrigger)
	
	DestroyEntity("blockade")
	
	-- Give player 2 to player 1
	Logic.ChangeAllEntitiesPlayerID(2, 1)
	AddStone(1000)
    AddClay(1000)
    AddGold(1000)
    AddSulfur(1000)
    AddIron(1000)
    AddWood(1000)
--	Logic.ChangeAllEntitiesPlayerID(3, 1)
	
	CitywallsPlayercolor = true
	InitPlayerColorMapping()

	-- remove names
	SetPlayerName(2,nil)
	SetPlayerName(4,nil)

	-- change color of walls
	Display.SetPlayerColorMapping(3,PLAYER_COLOR)
	Display.SetPlayerColorMapping(2,NEPHILIM_COLOR)
	SetFriendly(2,6)
	for i = 1,8,1 do
		if i ~= 2 then
			SetNeutral(2,i)
		end
	end

	ResolveBriefing(briefingPreludeRescueCityQuest)
	ResolveBriefing(briefingPreludeShowIronMine)

	start3rdChapter()
	
end

------------------------------------------------------------------------------
-- Build up big city defense
------------------------------------------------------------------------------
function start3rdChapter()

	StartCutscene(Cutscenes[THRESHOLDONECUTSCENE],CreateBriefingDefend)

end
function end3rdChapter()

	start4thChapter()

end

------------------------------------------------------------------------------
-- First Attackers Wave appear
------------------------------------------------------------------------------
function start4thChapter()

	-- fog banks spawn together with army
	ChangeDynamicFog("MiddleFog", 7, 10)
	
	CreatePlayer6()
	--SetPlayerName(4,"Nebelvolk")
	
	InitPlayerColorMapping()
		
	CreateArmyAttackers()

	CreateBriefingAttackers()

end
function end4thChapter()

	start5thChapter()
	
end
------------------------------------------------------------------------------
-- They will come back
------------------------------------------------------------------------------
function start5thChapter()

	-- fog banks spawn together with army
	--ChangeDynamicFog("RightFog", 5, 8)
	--ChangeDynamicFog("LeftFog", 6, 8)

	CreateArmyAttackers2()
	
	ResolveBriefing(briefingAttackersQuest)
	
	--CreateBriefingAttackersGone()

	CreateQuestDefend()

end
function end5thChapter()
	
	for _,_tablespot in ipairs(markerpostable) do
		GUI.DestroyMinimapPulse(_tablespot.X, _tablespot.Y)
	end
	
	--Disable QuestInformation
	--GUIQuestTools.DisableQuestInformation()


	CreateBriefingRiflemen()

	start6thChapter()
	
end
------------------------------------------------------------------------------
-- Destroy Nephilim
------------------------------------------------------------------------------
function start6thChapter()

	FinalAttackComming = true
	InitWeatherGfxSets()

	StartRain(60 * 1000000)

	CreateArmyFinalAttack()

	--AnSu: A cutscene will be startet thru this briefing. See briefing_finalAttack.lua
	CreateBriefingFinalAttack()

	CreateQuestFinalAttack()

end
function end6thChapter()

	StartRain(1)
	
	StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE],Victory)

end